<?php
header('Content-Type: application/json');

$method = isset($_GET['method']) ? $_GET['method'] : '';

$response = [
    "status" => "error",
    "message" => "Invalid contact method selected."
];

if ($method) {
    switch ($method) {
        case 'email':
            $response = [
                "status" => "success",
                "data" => "📧 Email us at <a href='mailto:info@weela.org'>info@weela.org</a>"
            ];
            break;

        case 'call':
            $response = [
                "status" => "success",
                "data" => "📞 Call us at <a href='tel:+255700000000'>+255 700 000 000</a>"
            ];
            break;

        case 'sms':
            $response = [
                "status" => "success",
                "data" => "💬 Send SMS to +255 700 000 000"
            ];
            break;

        case 'whatsapp':
            $response = [
                "status" => "success",
                "data" => "💬 Chat via WhatsApp: <a href='https://wa.me/255700000000' target='_blank' rel='noopener'>Click here</a>"
            ];
            break;
    }
}

echo json_encode($response);
